implementation module window;

import StdEnv;
import windows;

foreign export MainWndProc;
foreign export DrawThreadProc;

N_THREADS:==8;

//import StdDebug;

load_int :: !Int !Int -> (!Int,!Int);
load_int o p = code {
	push_b 1
	push_b 1
	addI
	load_i 0
	updatepop_b 0 1
}

store_int v o p :== IF_INT_64_OR_32 (store_int_64 v o p) (store_int_32 v o p);

store_int_64 :: !Int !Int !Int -> Int;
store_int_64 v o p = code {
	push_b 1
	pushI -8
	addI
	update_b 0 2
	pop_b 1

	push_b 2
	push_b 2
	addI
	push_b_a 0
	pop_b 1
	fill1_r _ 0 1 0 01
	push_a_b 0
	pop_a 1

	push_b 1
	push_b 1
	subI
	updatepop_b 0 3
}

store_int_32 :: !Int !Int !Int -> Int;
store_int_32 v o p = code {
	push_b 1
	pushI -4
	addI
	update_b 0 2
	pop_b 1

	push_b 2
	push_b 2
	addI
	push_b_a 0
	pop_b 1
	fill1_r _ 0 1 0 01
	push_a_b 0
	pop_a 1

	push_b 1
	push_b 1
	subI
	updatepop_b 0 3
}

lock_xadd_ws :: !Int !Int !*WinState -> (!Int,!Int,!*WinState);
lock_xadd_ws v p ws
	# (v,p) = lock_xadd v p;
	= (v,p,ws);

lock_xadd v p :== IF_INT_64_OR_32 (lock_xadd_64 v p) (lock_xadd_32 v p);

lock_xadd_32 :: !Int !Int -> (!Int,!Int);
lock_xadd_32 v p = code {
|	lock xadd %ebx,(%eax)
	instruction 0xf0
	instruction 0x0f
	instruction 0xc1
	instruction 0x18
}
// f0 0f c1 18 lock xadd %ebx,(%eax)

lock_xadd_64 :: !Int !Int -> (!Int,!Int);
lock_xadd_64 v p = code {
	instruction 0xf0
	instruction 0x48
	instruction 0x0f
	instruction 0xc1
	instruction 0x18
}

lock_cmpxchg new_value old_value p
	:== IF_INT_64_OR_32 (lock_cmpxchg_64 new_value old_value p) (lock_cmpxchg_32 new_value old_value p);

lock_cmpxchg_32 :: !Int !Int !Int -> (!Bool,!Int);
lock_cmpxchg_32 new_value old_value p = code {
|	movl (%esp),%ecx
	instruction 0x8b
	instruction 0x0c
	instruction 0x24
|	lock cmpxchg %ebx,(%ecx)
	instruction 0xf0
	instruction 0x0f
	instruction 0xb1
	instruction 0x19
|	sete %bl
	instruction 0x0f
	instruction 0x94
	instruction 0xc3
|	movzbl %bl,%ebx
	instruction 0x0f
	instruction 0xb6
	instruction 0xdb
	update_b 1 2
	update_b 0 1
	pop_b 1
}
//8b 0c 24    movl (%esp),%ecx
//f0 0f b1 19 lock cmpxchg %ebx,(%ecx)
//0f 94 c3    sete %bl
//0f b6 db    movzbl %bl,%ebx

lock_cmpxchg_64 :: !Int !Int !Int -> (!Bool,!Int);
lock_cmpxchg_64 new_value old_value p = code {
|	mov r11,rax
	instruction 0x4C
	instruction 0x8B
	instruction 0xD8
|	mov rax,rbx
	instruction 0x48
	instruction 0x8B
	instruction 0xC3
|	lock cmpxchg qword ptr [r11],r10
	instruction 0xF0
	instruction 0x4D
	instruction 0x0F
	instruction 0xB1
	instruction 0x13
|	sete bl
	instruction 0x0F
	instruction 0x94
	instruction 0xC3
|	movzx ebx,bl
	instruction 0x0F
	instruction 0xB6
	instruction 0xDB
	pop_b 1
}
//4C 8B D8       mov r11,rax
//48 8B C3       mov rax,rbx
//F0 4D 0F B1 13 lock cmpxchg qword ptr [r11],r10
//0F 94 C3       sete bl
//0F B6 DB       movzx ebx,bl

sync_pointer :: !Int !*WinState -> *WinState;
sync_pointer p ws = ws;

clean_new_thread_address :: Int;
clean_new_thread_address = code {
|	pushLc clean_new_thread
	pushL clean_new_thread
}

DrawThreadProc_address :: Int;
DrawThreadProc_address = code {
|	pushLc DrawThreadProc
	pushL DrawThreadProc
}

CALL_BACK_DATA_OFFSET:==IF_INT_64_OR_32 24 8;
THREAD_N_OFFSET:==IF_INT_64_OR_32 32 16;

CALL_BACK_DATA_CRITICAL_SECTION_OFFSET:==0;
CALL_BACK_DATA_BEGIN_WORK_EVENT_OFFSET:==IF_INT_64_OR_32 8 4;
CALL_BACK_DATA_FINISHED_WORK_EVENT_OFFSET:==IF_INT_64_OR_32 16 8;
CALL_BACK_DATA_HDC_OFFSET:==IF_INT_64_OR_32 24 12;
CALL_BACK_DATA_WORK_COUNTER_OFFSET:==64;

CALL_BACK_DATA_BLOCK_INDEX_OFFSET:==128;
CALL_BACK_DATA_N_BLOCKS_INDEX_OFFSET:==192;
CALL_BACK_DATA_BLOCKS_OFFSET:==256;

CALL_BACK_DATA_SIZE_BYTES:==4352; // 256+64*64;

import StdDebug;

DrawThreadProc :: !LPVOID -> DWORD;
DrawThreadProc p
  # (call_back_data_p,p) = load_int CALL_BACK_DATA_OFFSET p;
  # (critical_section,call_back_data_p) = load_int CALL_BACK_DATA_CRITICAL_SECTION_OFFSET call_back_data_p;
  #! (begin_work_event,call_back_data_p) = load_int CALL_BACK_DATA_BEGIN_WORK_EVENT_OFFSET call_back_data_p;
//#! (thread_n,p) = load_int THREAD_N_OFFSET p;
  # ws = 0
  = loop critical_section begin_work_event call_back_data_p ws;
where {
	loop :: !HANDLE !HANDLE !HANDLE !WinState -> DWORD;
	loop critical_section begin_work_event call_back_data_p ws
		# (_,ws) = WaitForSingleObject begin_work_event INFINITE ws;
		# (call_back_data_p,ws) = draw_mandelbrot critical_section call_back_data_p ws;
		# (call_back_data_p,ws) = draw_mandelbrot_end begin_work_event call_back_data_p ws;
		= loop critical_section begin_work_event call_back_data_p ws;

	draw_mandelbrot :: !Int !Int !*Int -> (!Int,!*Int);
	draw_mandelbrot critical_section call_back_data_p ws
		# (hdc,call_back_data_p) = load_int CALL_BACK_DATA_HDC_OFFSET call_back_data_p;
		 (n_blocks,call_back_data_p) = load_int CALL_BACK_DATA_N_BLOCKS_INDEX_OFFSET call_back_data_p;
		 (block_index,call_back_data_p) = load_int CALL_BACK_DATA_BLOCK_INDEX_OFFSET call_back_data_p;
		= draw_mandelbrot_blocks block_index n_blocks hdc critical_section call_back_data_p ws;

	draw_mandelbrot_blocks :: !Int !Int !Int !Int !Int !*Int -> (!Int,!*Int);
	draw_mandelbrot_blocks block_index n_blocks hdc critical_section call_back_data_p ws
		| block_index<n_blocks
			# (ok,current_block_index) = lock_cmpxchg (block_index+1) block_index (CALL_BACK_DATA_BLOCK_INDEX_OFFSET+call_back_data_p);
			| not ok
				= draw_mandelbrot_blocks current_block_index n_blocks hdc critical_section call_back_data_p ws;
			# offset = CALL_BACK_DATA_BLOCKS_OFFSET + (block_index<<6);
			  (x_begin,call_back_data_p) = load_int offset call_back_data_p;
			  (y_begin,call_back_data_p) = load_int (offset+8) call_back_data_p;
			  (x_end,call_back_data_p) = load_int (offset+16) call_back_data_p;
			  (y_end,call_back_data_p) = load_int (offset+24) call_back_data_p;
			#! ws = set_pixels_yx_ y_begin y_end x_begin x_end hdc critical_section ws;
			= draw_mandelbrot_blocks (block_index+1) n_blocks hdc critical_section call_back_data_p ws;
		= (call_back_data_p,ws);

	draw_mandelbrot_end :: !Int !Int !*Int -> (Int,!*Int);
	draw_mandelbrot_end begin_work_event call_back_data_p ws
		# (old_work_counter,_,ws) = lock_xadd_ws -1 (call_back_data_p+CALL_BACK_DATA_WORK_COUNTER_OFFSET) ws;
		# (finished_work_event,call_back_data_p) = load_int CALL_BACK_DATA_FINISHED_WORK_EVENT_OFFSET call_back_data_p;
		| old_work_counter==1

//			&& trace_tn ("!")

		 	# call_back_data_p = store_int 0 CALL_BACK_DATA_HDC_OFFSET call_back_data_p;
		 	# ws = sync_pointer call_back_data_p ws;

			# (_,ws) = ResetEvent begin_work_event ws;
			# (_,ws) = SetEvent finished_work_event ws;
			= (call_back_data_p,ws);
			# (_,ws) = WaitForSingleObject finished_work_event INFINITE ws;
			= (call_back_data_p,ws);
}

MainWndProc :: !HWND !UINT !WPARAM !LPARAM -> LRESULT;
MainWndProc hwnd WM_CREATE wParam lParam
  =	0;
MainWndProc hwnd WM_SIZE wParam lParam
  =	0;
MainWndProc hwnd WM_DESTROY wParam lParam
  =	PostQuitMessage 0 0;
MainWndProc hwnd WM_PAINT wParam lParam
	# ws=0;
	  (b,ws) = GetUpdateRect hwnd NULL 0 ws;
	| b==0
		= ws;
	# (call_back_data_p,ws) = GetWindowLongPtr hwnd GWL_USERDATA ws;
	  (critical_section,call_back_data_p) = load_int CALL_BACK_DATA_CRITICAL_SECTION_OFFSET call_back_data_p;

	# paint = createArray 72 '\0';
	#! (hdc,ws) = BeginPaint hwnd paint ws;

//  | not (trace_t "(")
//		= undef;

	# call_back_data_p = store_int hdc CALL_BACK_DATA_HDC_OFFSET call_back_data_p;

	  (begin_work_event,call_back_data_p) = load_int CALL_BACK_DATA_BEGIN_WORK_EVENT_OFFSET call_back_data_p;
	  (finished_work_event,call_back_data_p) = load_int CALL_BACK_DATA_FINISHED_WORK_EVENT_OFFSET call_back_data_p;

	# call_back_data_p = store_int N_THREADS CALL_BACK_DATA_WORK_COUNTER_OFFSET call_back_data_p;

	# call_back_data_p = store_blocks 0 0 CALL_BACK_DATA_BLOCKS_OFFSET call_back_data_p;
	  call_back_data_p = store_int 0 CALL_BACK_DATA_BLOCK_INDEX_OFFSET call_back_data_p;
	  call_back_data_p = store_int 64 CALL_BACK_DATA_N_BLOCKS_INDEX_OFFSET call_back_data_p;

	# ws = sync_pointer call_back_data_p ws;

	#! (_,ws) = SetEvent begin_work_event ws;
/*
	| not (trace_tn "(")
		= undef;
*/
	#! (_,ws) = WaitForSingleObject finished_work_event INFINITE ws;

/*
	# ws = wait_thread thread_handle1 p1 ph ws;
	  ws = wait_thread thread_handle2 p2 ph ws;
 	  ws = wait_thread thread_handle3 p3 ph ws;
*/
	# (_,ws) = ResetEvent finished_work_event ws;
/*
//	| not (trace_tn "EndPaint")
	| not (trace_tn ")")
		= undef;
*/
	# (b,ws) = EndPaint hwnd paint ws;
	= ws;
MainWndProc hwnd msg wParam lParam
//| trace_tn ("MainWndProc "+++toString msg)
  = DefWindowProc_NoWinState hwnd msg wParam lParam;
//= abort "MainWndProc";

store_blocks :: !Int !Int !Int !Int -> Int;
store_blocks x y offset call_back_data_p
	| x<8
		# bx = 125*x;
		  by = 100*y;
		  call_back_data_p = store_int bx offset call_back_data_p;
		  call_back_data_p = store_int by (offset+8) call_back_data_p;
		  call_back_data_p = store_int (bx+125) (offset+16) call_back_data_p;
		  call_back_data_p = store_int (by+100) (offset+24) call_back_data_p;
		= store_blocks (x+1) y (offset+64) call_back_data_p;
	# y=y+1;
	| y<8
		= store_blocks 0 y offset call_back_data_p;
		= call_back_data_p;

alloc_3 drawThreadProc_address call_back_data_p thread_n ph ws
  #	(p1,ws) = HeapAlloc ph 0 (5<<(IF_INT_64_OR_32 3 2)) ws;
  | p1==NULL
  	= abort "HeapAlloc failed";
  # p1 = store_int drawThreadProc_address 0 p1;
    p1 = store_int 0 (IF_INT_64_OR_32 8 4) p1;
    p1 = store_int 0 (IF_INT_64_OR_32 16 8) p1;
	p1 = store_int call_back_data_p CALL_BACK_DATA_OFFSET p1;
  #!p1 = store_int thread_n THREAD_N_OFFSET p1;
  = (p1,ws);

wait_thread thread_handle p ph ws
  #	(r,ws) = WaitForSingleObject thread_handle INFINITE ws;
	ws = CloseHandle thread_handle ws;
	(b,ws) = HeapFree ph 0 p ws;
  |	b==0
  	= abort "HeapFree failed";
  	= ws;

set_pixels :: !Int !Int !Int !Int !{#Int} !Int !WinState -> WinState;
set_pixels x y nx ny b hdc ws
	# a32 = {createArray 10 0 &
			[0] = 40,						// biSize
			[1] = nx,						// biWidth
			[2] = ~ny,						// biHeight
			[3] = 1+(32<<16),				// biPlanes, biBitCount
			[4] = KS_BI_RGB,				// biCompression
			[5] = 0,						// biSizeImage
			[6] = 3780,						// biXPelsPerMeter, 3780 = 96 DPI
			[7] = 3780,						// biYPelsPerMeter, 3780 = 96 DPI
			[8] = 0,						// biClrUsed
			[9] = 0							// biClrImportant
			};
	# a64 = {createArray 5 0 &
			[0] = 40 + (nx<<32),								// biSize,  biWidth
			[1] = (~ny bitand 0xffffffff) + (1<<32)+(32<<48),	// biHeigh, biPlanes, biBitCount
			[2] = KS_BI_RGB /*+ (0<<32)*/,						// biCompression, biSizeImage
//			[3] = 3780 + (3780<<32),							// biXPelsPerMeter, biYPelsPerMeter, 3780 = 96 DPI
			[3] = 0 + (0<<32),									// biXPelsPerMeter, biYPelsPerMeter
			[4] = 0												// biClrUsed, biClrImportant
			};
	# a = IF_INT_64_OR_32 a64 a32;
	# (r,ws) = SetDIBitsToDevice hdc x y nx ny 0 0 0 ny b a DIB_RGB_COLORS ws;
	| r<>0
		= ws;
  		# (e,ws) = GetLastError ws;
//	  	| trace_tn ("SetDIBitsToDevice failed "+++toString e+++" "+++toString hdc)
	  	| trace_t ("*")
	  		= ws;
//	  	= abort ("SetDIBitsToDevice failed "+++toString e);
/*
		# s= //"SetDIBitsToDevice failed "+++
				toString e
				+++" x = "+++toString x
				+++" y = "+++toString y
				+++" nx = "+++toString nx
				+++" ny = "+++toString ny
				+++" hdc = "+++toString hdc
				+++" &b = "+++toHex (array_address b)
				+++" &a = "+++toHex (array_address a)
				+++" size b = "+++toString (size b)
				+++ "\n{"+++print_array 0 a+++"}"
				+++ "\n{"+++print_array 0 b+++"}"
	  			;
	  	| trace_tn s
	  		= ws;
*/

print_array i a
	| i<size a
		= toHex a.[i]+++","+++print_array (i+1) a;
		= "";

toHex :: !Int -> *{#Char};
toHex n = {toHexChar ((n>>((15-i)<<2)) bitand 15) \\ i<-[0..15]};

toHexChar i
	| i<10
		= toChar (48+i);
		= toChar (55+i);

array_address :: !{#Int} -> Int;
array_address a = code {
	push_a_b 0
	pop_a 1
}

set_pixels_xy :: !Int !Int !Int !Int !HDC !WinState -> WinState;
set_pixels_xy x x_end y_begin y_end hdc ws
  |	x<x_end
	  # ws = set_pixels_y x y_begin y_end hdc ws;
	  = set_pixels_xy (x+1) x_end y_begin y_end hdc ws;
	  = ws;

set_pixels_y :: !Int !Int !Int !HDC !WinState -> WinState;
set_pixels_y x y y_end hdc ws
  | y<y_end
	  #! c = fractal_pixel_color x y;
		(b,ws) = SetPixelV hdc x y c ws;
	  = set_pixels_y x (y+1) y_end hdc ws;
	  = ws;

MAX_N_PIXELS :== 32;
/*
set_pixels_yx :: !Int !Int !Int !Int !HDC !WinState -> WinState;
set_pixels_yx y y_end x_begin x_end hdc ws
  |	y<y_end
//	  # ws = set_pixels_x y x_begin x_end 0 (createArray ((MAX_N_PIXELS+1)>>1) 0) hdc ws;
	  # ws = set_pixels_x y x_begin x_end 0 (createArray MAX_N_PIXELS 0) hdc ws;
	  = set_pixels_yx (y+1) y_end x_begin x_end hdc ws;
	  = ws;
{}{
	set_pixels_x :: !Int !Int !Int !Int !*{#Int} !HDC !WinState -> WinState;
	set_pixels_x y x x_end n_pixels ca hdc ws
	  | x<x_end
		  | n_pixels<MAX_N_PIXELS
				# c = fractal_pixel_bgr_color x y;
/*
				# i = n_pixels>>1;
				# (ci,ca) = ca![i];
				# ca = {ca & [i]=ci bitor c<<((n_pixels bitand 1)<<5)};
*/
				# i = n_pixels;
				# (ci,ca) = ca![i];
				# ca = {ca & [i]=ci bitor c};

				= set_pixels_x y (x+1) x_end (n_pixels+1) ca hdc ws;
				# ws = set_pixels (x-n_pixels) y n_pixels 1 ca hdc ws;
//				= set_pixels_x y x x_end 0 (createArray ((MAX_N_PIXELS+1)>>1) 0) hdc ws;
				= set_pixels_x y x x_end 0 (createArray MAX_N_PIXELS 0) hdc ws;
			| n_pixels<>0
				= set_pixels (x-n_pixels) y n_pixels 1 ca hdc ws;
			 	= ws;
}
*/

set_pixels_yx_ :: !Int !Int !Int !Int !HDC !LPCRITICAL_SECTION !WinState -> WinState;
set_pixels_yx_ y y_end x_begin x_end hdc critical_section ws
  |	y<y_end
	  # ws = set_pixels_x_ y x_begin x_end 0 (createArray (IF_INT_64_OR_32 ((MAX_N_PIXELS+1)>>1) MAX_N_PIXELS) 0) hdc critical_section ws;
	  = set_pixels_yx_ (y+1) y_end x_begin x_end hdc critical_section ws;
	  = ws;

set_pixels_x_ :: !Int !Int !Int !Int !*{#Int} !HDC !LPCRITICAL_SECTION !WinState -> WinState;
set_pixels_x_ y x x_end n_pixels ca hdc critical_section ws
  | x<x_end
	  | n_pixels<MAX_N_PIXELS
			# c = fractal_pixel_bgr_color x y;
			# i = IF_INT_64_OR_32 (n_pixels>>1) n_pixels;
			# (ci,ca) = ca![i];
			# ca = {ca & [i]=ci bitor (IF_INT_64_OR_32 (c<<((n_pixels bitand 1)<<5)) c)};
			= set_pixels_x_ y (x+1) x_end (n_pixels+1) ca hdc critical_section ws;
			# ws = EnterCriticalSection critical_section ws;
			  ws = set_pixels (x-n_pixels) y n_pixels 1 ca hdc ws;
			  ws = LeaveCriticalSection critical_section ws;
			= set_pixels_x_ y x x_end 0 (createArray (IF_INT_64_OR_32 ((MAX_N_PIXELS+1)>>1) MAX_N_PIXELS) 0) hdc critical_section ws;
		| n_pixels<>0
			# ws = EnterCriticalSection critical_section ws;
			  ws = set_pixels (x-n_pixels) y n_pixels 1 ca hdc ws;
			  ws = LeaveCriticalSection critical_section ws;
			= ws;
		 	= ws;
/*
set_pixels_xy_ :: !Int !Int !Int !Int !HDC !LPCRITICAL_SECTION !WinState -> WinState;
set_pixels_xy_ x x_end y_begin y_end hdc critical_section ws
  |	x<x_end
	  # ws = set_pixels_y_ x y_begin y_end hdc critical_section ws;
	  = set_pixels_xy_ (x+1) x_end y_begin y_end hdc critical_section ws;
	  = ws;

set_pixels_y_ :: !Int !Int !Int !HDC !LPCRITICAL_SECTION !WinState -> WinState;
set_pixels_y_ x y y_end hdc critical_section ws
  | y<y_end
	  #	(b,ws) = set_pixel_ hdc x y critical_section ws;
	  = set_pixels_y_ x (y+1) y_end hdc critical_section ws;
	  = ws;

set_pixel_ :: !Int !Int !Int !Int !*Int -> (!Int,!*Int);
set_pixel_ hdc x y critical_section ws
  #! c=fractal_pixel_color x y;
  #	ws = EnterCriticalSection critical_section ws;
	(b,ws) = SetPixelV hdc x y c ws;
	ws = LeaveCriticalSection critical_section ws;
  =	(b,ws);
*/
get_MainWndProc_address :: Int;
get_MainWndProc_address = code {
|	pushLc MainWndProc
	pushL MainWndProc
}

// RGB colors for SetPixelV

rgb_color 0 = 0x000000;
rgb_color 1 = 0xff0000;
rgb_color 2 = 0x00ff00;
rgb_color 3 = 0x0000ff;
rgb_color 4 = 0xffff00;
rgb_color 5 = 0x00ffff;
rgb_color 6 = 0xff00ff;
rgb_color 7 = 0xffffff;

// BGR colors for SetDIBitsToDevice

bgr_color 0 = 0x000000;
bgr_color 1 = 0x0000ff;
bgr_color 2 = 0x00ff00;
bgr_color 3 = 0xff0000;
bgr_color 4 = 0x00ffff;
bgr_color 5 = 0xffff00;
bgr_color 6 = 0xff00ff;
bgr_color 7 = 0xffffff;

fractal_pixel_color x y 
  #	w=1000.0;
	h= 800.0;
	c = (2.0*toReal x/w - 1.5, 2.0*toReal y/h - 1.0);
  	n = fractal (0.0,0.0) 0 c;
  = rgb_color (n bitand 7);  	

fractal_pixel_bgr_color x y 
  #	w=1000.0;
	h= 800.0;
	c = (2.0*toReal x/w - 1.5, 2.0*toReal y/h - 1.0);
  	n = fractal (0.0,0.0) 0 c;
  = bgr_color (n bitand 7);  	

//Depth :== 256;
Depth :== 512;

fractal :: !(!Real,!Real) !Int !(!Real,!Real) -> Int;
fractal (r,i) iter c=:(cr,ci)
	# (r2,i2) = (r*r,i*i);
	| r2 + i2 <= 4.0
		| iter < Depth
			# pri=r*i;
			= fractal (r2-i2+cr,pri+pri+ci) (iter+1) c;
//			= fractal (r2-i2+cr,2.0*pri+ci) (iter+1) c;
			= iter;
		= iter;

init_application h_instance ws
  #	(h_icon,ws) = LoadIcon NULL IDI_APPLICATION ws;
	(h_cursor,ws) = LoadCursor NULL IDC_ARROW ws;
	(cxsm_icon,ws) = GetSystemMetrics SM_CXSMICON ws;
	(cysm_icon,ws) = GetSystemMetrics SM_CYSMICON ws;
	(icon_sm,ws) = LoadImage h_instance 5 IMAGE_ICON cxsm_icon cysm_icon LR_DEFAULTCOLOR ws;
	(white_brush,ws) = GetStockObject WHITE_BRUSH ws;
  =	RegisterClassEx
  	(IF_INT_64_OR_32
  		{
  		   /*cbSize,style*/ 80 + ((CS_HREDRAW bitor CS_VREDRAW)<<32),
			/*lpfnWndProc*/ get_MainWndProc_address,
				/*cbClsExtra,cbWndExtra*/ (8<<32), //0,
			/*hInstance*/ h_instance,
			/*hIcon*/ h_icon,
			/*hCursor*/ h_cursor,
			/*hbrBackground*/ white_brush,
			/*lpszMenuName*/ string_constant_to_pointer "MainMenu\0",
			/*lpszClassName*/ string_constant_to_pointer "MainWClass\0",
			/*hIconSm*/ icon_sm
		}
  		{
  		   /*cbSize*/ 48,
  			/*style*/ (CS_HREDRAW bitor CS_VREDRAW),
			/*lpfnWndProc*/ get_MainWndProc_address,
			/*cbClsExtra*/ 0,
			/*cbWndExtra*/ 8,
			/*hInstance*/ h_instance,
			/*hIcon*/ h_icon,
			/*hCursor*/ h_cursor,
			/*hbrBackground*/ white_brush,
			/*lpszMenuName*/ string_constant_to_pointer "MainMenu\0",
			/*lpszClassName*/ string_constant_to_pointer "MainWClass\0",
			/*hIconSm*/ icon_sm
		}
		) ws;

message_loop message ws
  #	(r,ws) = GetMessage message NULL 0 0 ws;
  | r==0 || r== -1
	= ws;
  #	(r,ws) = TranslateMessage message ws;
	(r,ws) = DispatchMessage message ws;
  =	message_loop message ws;

/*
f :: !Int -> Int;
f i = code {
	ccall f "GI:I"
}

foreign export gc;

gc :: !{#Char} !Int -> Int;
gc a n = n + size a;
*/

Start
//  = f;
  #	ws = 123456789;
	(h_instance,ws) = GetModuleHandle NULL ws;
	(atom,ws) = init_application h_instance ws;
  | atom==NULL
	= abort "init_application failed";
  # x=70;
  	y=20;
  	w=1000+8;
// 	h=800+34;
  	h=800+30;
  #	(hwnd,ws) = CreateWindowEx 0 "MainWClass\0" "Sample\0" WS_OVERLAPPEDWINDOW x y w h NULL NULL h_instance NULL ws;
  |	hwnd==NULL
  	# (e,ws) = GetLastError ws;
  	= abort ("CreateWindowEx failed "+++toString e);

  # (ph,ws) = GetProcessHeap ws;
	(call_back_data_pb,ws) = HeapAlloc ph 0 (CALL_BACK_DATA_SIZE_BYTES+63) ws;
	call_back_data_p = (call_back_data_pb+63) bitand -64;

 	(critical_section,ws) = HeapAlloc ph 0 CRITICAL_SECTION_SIZE_BYTES ws;
	ws = InitializeCriticalSection critical_section ws;
	(begin_work_event,ws) = CreateEvent 0 1 0 0 ws;
	(finished_work_event,ws) = CreateEvent 0 1 0 0 ws;

	call_back_data_p = store_int critical_section CALL_BACK_DATA_CRITICAL_SECTION_OFFSET call_back_data_p;
	call_back_data_p = store_int begin_work_event CALL_BACK_DATA_BEGIN_WORK_EVENT_OFFSET call_back_data_p;
	call_back_data_p = store_int finished_work_event CALL_BACK_DATA_FINISHED_WORK_EVENT_OFFSET call_back_data_p;

	(_,ws) = SetWindowLongPtr hwnd GWL_USERDATA call_back_data_p ws;

   	(ph,ws) = GetProcessHeap ws;
    drawThreadProc_address = DrawThreadProc_address;

	(_,ws) = create_threads 0 N_THREADS call_back_data_p ph drawThreadProc_address ws;

    (r1,ws) = ShowWindow hwnd SW_SHOWNORMAL ws;
	(r2,ws) = UpdateWindow hwnd ws;
	message = createArray 48 '\0';
	ws=message_loop message ws;
  =	(h_instance,atom,hwnd,r1,r2,ws);

create_threads thread_n n_threads call_back_data_p ph drawThreadProc_address ws
	| thread_n<n_threads
 		# (p,ws) = alloc_3 drawThreadProc_address call_back_data_p thread_n ph ws;  
   		  (thread_handle,thread_id1,ws) = CreateThread 0 0 clean_new_thread_address p 0 ws;
		#! (threads_pointers,ws) = create_threads (thread_n+1) n_threads call_back_data_p ph drawThreadProc_address ws;
		= ([(thread_handle,p):threads_pointers],ws);
		= ([],ws);
